<?php $title = isset($title) ? $title : 'Tanko';
?>

<!-- Desktop Navbar -->
<header class="justify-content-between align-items-center px-4 py-3 mw--1440 d-none d-lg-flex" id="desktopNavbar">
    <div>
        <a href="<?php echo __ROOT__; ?>/">
            <img src="<?php echo __ROOT__; ?>/public/img/logo.png" alt="Logo" class="logo" width="170.48" height="50.24">
        </a>
    </div>
    <div>
        <nav class="d-flex">
            <ul class="d-flex list-unstyled align-items-center m-0 text-center">
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/">Home</a></li>
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/about">Who we are</a></li>
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/our-tents">Our tents</a></li>
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/experiences">Our experiences</a></li>
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/meetings-and-events">Meetings & Events</a></li>
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/romantic-packages">Romantic packages</a></li>
                <li><a class="a--black mx-3 inter inter--400 text--sm" href="<?php echo __ROOT__; ?>/contact">Contact</a></li>
                <li>
                    <a href="https://direct-book.com/properties/salterraglampingdirect?locale=en&referrer=canvas&items[0][adults]=2&items[0][children]=0&items[0][infants]=0&currency=MXN&checkInDate=2025-04-15&checkOutDate=2025-04-16&trackPage=yes" target="_blank" class="btn btn-dark text-white mw--max-content py-2 px-4">
                        <span class="me-2">Book Now</span>
                        <i class="fa-solid fa-arrow-right"></i>
                    </a>
                </li>
                <li>
                    <a href="https://wa.me/+524421693408" target="_blank" class="a--black mx-3">
                        <i class="fa-brands fa-whatsapp fa-2x"></i>
                    </a>
                </li>
            </ul>

        </nav>
    </div>
    <div id="floating-buttons" class="position-fixed d-flex fade-scroll" style="top: 10px;">
        <div>
            <a href="https://direct-book.com/properties/salterraglampingdirect?locale=en&referrer=canvas&items[0][adults]=2&items[0][children]=0&items[0][infants]=0&currency=MXN&checkInDate=2025-04-15&checkOutDate=2025-04-16&trackPage=yes" target="_blank" class="btn btn-dark text-white mw--max-content py-2 px-4">
                <span class="me-2">Book Now</span>
                <i class="fa-solid fa-arrow-right"></i>
            </a>
        </div>
        <div>
            <a href="https://wa.me/+524421693408" target="_blank" class="a--black mx-3">
                <i class="fa-brands fa-whatsapp fa-2x"></i>
            </a>
        </div>
    </div>
</header>

<!-- Mobile Navbar -->
<header class="d-lg-none">
    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo __ROOT__; ?>">
                <img src="<?php echo __ROOT__; ?>/public/img/logo.png" alt="Logo" class="logo" width="85.24" height="25.12">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse px-2" id="navbarNav">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'Home') ? 'active' : ''; ?>" aria-current="page" href="<?php echo __ROOT__; ?>/">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'About') ? 'active' : ''; ?>" href="<?php echo __ROOT__; ?>/about">Who we are</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'Our Tents') ? 'active' : ''; ?>" href="<?php echo __ROOT__; ?>/our-tents">Our tents</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'Experiences') ? 'active' : ''; ?>" href="<?php echo __ROOT__; ?>/experiences">Our experiences</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'Meetings & Events') ? 'active' : ''; ?>" href="<?php echo __ROOT__; ?>/meetings-and-events">Meetings & Events</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'Romantic Packages') ? 'active' : ''; ?>" href="<?php echo __ROOT__; ?>/romantic-packages">Romantic packages</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link inter inter--400 <?php echo ($title == 'Contact') ? 'active' : ''; ?>" href="<?php echo __ROOT__; ?>/contact">Contact</a>
                    </li>
                    <li class="nav-item">
                        <a href="https://wa.me/+524421693408" target="_blank" class="nav-link">
                            <i class="fa-brands fa-whatsapp fa-2x"></i>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a href="https://direct-book.com/properties/salterraglampingdirect?locale=en&referrer=canvas&items[0][adults]=2&items[0][children]=0&items[0][infants]=0&currency=MXN&checkInDate=2025-04-15&checkOutDate=2025-04-16&trackPage=yes" target="_blank" class="btn btn-dark text-white mw--max-content py-2 px-4">
                            <span class="me-2">Book Now</span>
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </li>

                </ul>
            </div>
        </div>
    </nav>
    <div class="position-fixed d-flex w-100 justify-content-between p-3" style="left: 0; bottom: 0; z-index: 10">
        <div>
            <a href="https://direct-book.com/properties/salterraglampingdirect?locale=en&referrer=canvas&items[0][adults]=2&items[0][children]=0&items[0][infants]=0&currency=MXN&checkInDate=2025-04-15&checkOutDate=2025-04-16&trackPage=yes" target="_blank" class="btn btn-dark text-white mw--max-content py-2 px-4">
                <span class="me-2">Book Now</span>
                <i class="fa-solid fa-arrow-right"></i>
            </a>
        </div>
        <div>
            <a href="https://wa.me/+524421693408" target="_blank" class="a--black mx-3">
                <i class="fa-brands fa-whatsapp fa-2x"></i>
            </a>
        </div>
    </div>
</header>

<script>
    const el = document.getElementById('floating-buttons');
    const startScroll = 50; // Desde qué scroll empieza a aparecer
    const endScroll = 100;   // A qué scroll ya está totalmente visible

    window.addEventListener('scroll', () => {
        const scrollTop = window.scrollY;

        if (scrollTop < startScroll) {
            el.style.opacity = 0;
        } else if (scrollTop > endScroll) {
            el.style.opacity = 1;
        } else {
            // Escalar la opacidad entre 0 y 1
            const progress = (scrollTop - startScroll) / (endScroll - startScroll);
            el.style.opacity = progress;
        }
    });
</script>
