<?php include 'partials/header.php'; ?>
<?php include 'partials/navbar.php'; ?>

<main>
    <!-- Section Hero -->
    <section class="mw--1440 home__hero">
        <div class="w-100">
            <img src="<?php echo __ROOT__; ?>/public/img/romantic/hero.jpeg" class="w-100" alt="Fondo"/>
        </div>
        <div class="hero__bg">
            <div class="hero__bg--content">
                <h2 class="text--white playfair playfair--800 text--2xl m-0 p-0">Romantic
                    packages</h2>
            </div>
        </div>
    </section>

    <section class="mw--1440 py-4 px-4 px-md-5">
        <header class="my-2 px-3 px-md-5">
            <ul class="list-unstyled list--tents">
                <li>
                    <button class="btn btn-transparent btn--fit px-5 a--black" onclick="togglePackage('Compromiso')">
                        Paquete compromiso
                    </button>
                </li>
                <li>
                    <button class="btn btn-transparent btn--fit px-5 a--black" onclick="togglePackage('Aniversario')">
                        Paquete aniversario
                    </button>
                </li>
                <li>
                    <button class="btn btn-transparent btn--fit px-5 a--black" onclick="togglePackage('Teppee')">
                        Teppee date
                    </button>
                </li>
                <li>
                    <button class="btn btn-transparent btn--fit px-5 a--black" onclick="togglePackage('Cabana')">
                        Cena romántica
                    </button>
                </li>
                <li>
                    <button class="btn btn-transparent btn--fit px-5 a--black" onclick="togglePackage('Armonia')">
                        Armonía Salterra Spa
                    </button>
                </li>
            </ul>
        </header>
    </section>

    <!-- Galery -->
    <section class="mw--1440 py-4 px-4 px-md-5">
        <div id="paqueteCompromiso">
            <div class="romantic__galery">
                <div class="grid--3cols romantic__galery--images">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/g1.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/g2.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/g3.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/g4.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/g5.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/g6.png">
                </div>
                <div class="romantic__galery--bg">
                </div>
            </div>
            <div class="row m-0 p-0 py-4 ">
                <div class="col-md-5 p-0 m-0 pb-4 p-lg-3 align-content-center">
                    <h3 class="playfair playfair--400 text--xl">Salterra Glamping</h3>
                    <p class="poppins poppins--400 text--grey text--sm">
                        Disfruta del aire libre en nuestros alojamientos exclusivos en tiendas de campaña tipo safari.
                        Experimenta cielos nocturnos estrellados, paisajes extraordinarios, y cenas románticas con tu
                        pareja.
                        Nuestras tiendas de campaña de lona están inspiradas en los safaris y cuentan con baños privados
                        y
                        camas
                        confortables.
                    </p>
                    <div class="mt-5">
                        <a href="<?php echo __ROOT__; ?>/book-now" class="btn btn--grey py-3 px-4">
                            <span class="me-2">Book now</span>
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
                <div class="col-md-7 p-0 m-0">
                    <img src="<?php echo __ROOT__; ?>/public/img/home/whoWeAre.png" alt="Who we are Image"
                         class="w-100">
                </div>
            </div>
        </div>
        <div id="paqueteAniversario">
            <div class="romantic__galery">
                <div class="grid--3cols romantic__galery--images">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an1.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an2.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an3.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an4.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an5.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a6.png">
                </div>
                <div class="romantic__galery--bg">
                </div>
            </div>
            <div>
                <div class="bg--light-grey px-4 px-md-5 py-4 my-4">
                    <ul class="list-unstyled d-flex justify-content-between m-0 p-0">
                        <li class="d-flex align-items-center">
                            <img src="<?php echo __ROOT__; ?>/public/img/romantic/iconOutdoor.png" alt="icono outdoor"
                                 width="24" height="24" class="me-2">
                            <h4 class="poppins poppins--400 text--sm m-0 p-0">Outdoor Setting</h4>
                        </li>
                        <li class="d-flex align-items-center">
                            <img src="<?php echo __ROOT__; ?>/public/img/romantic/iconRoom.png" alt="icono room service"
                                 width="24" height="24" class="me-2">
                            <h4 class="poppins poppins--400 text--sm m-0 p-0">Room Service</h4>
                        </li>
                        <li class="d-flex align-items-center">
                            <img src="<?php echo __ROOT__; ?>/public/img/romantic/iconWifi.png" alt="icono wireless"
                                 width="24" height="24" class="me-2">
                            <h4 class="poppins poppins--400 text--sm m-0 p-0">Wireless Internet</h4>
                        </li>
                    </ul>
                </div>
                <div class="text--grey poppins poppins--400 text--sm">
                    <p>
                        El amor se celebra mejor en un lugar que lo inspire...
                    </p>
                    <p>
                        Nuestro Paquete Aniversario es la mezcla perfecta de aventura, calma y romance:
                    </p>
                    <ul class="m-0 p-0 ms-3">
                        <li>Noche mágica en una habitación tipo safari</li>
                        <li>Decoración romántica de la habitación</li>
                        <li>Cocina tu propia pizza al horno en pareja</li>
                        <li>Relájense juntos en sauna y jacuzzi durante 120 minutos</li>
                        <li>Disfruten de una tabla gourmet con botella de vino</li>
                        <li>Y despierten con un desayuno frente a la naturaleza</li>

                    </ul>
                    <p>
                        Hagan de su aniversario una historia que quieran repetir…El amor merece una experiencia así…
                    </p>
                    <p>
                        Haz clic aquí para un recorrido virtual por la tienda:
                        <a href="https://my.matterport.com/show/?m=SqSeTG7rLD1" target="_blank" class="a--grey">https://my.matterport.com/show/?m=SqSeTG7rLD1</a>
                    </p>
                </div>
            </div>
        </div>
        <div id="paqueteTeppee">
            <div class="romantic__galery">
                <div class="grid--3cols romantic__galery--images">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an1.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/t2.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an3.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an4.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an5.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/an6.png">
                </div>
                <div class="romantic__galery--bg">
                </div>
            </div>
            <div>
                <div class="text--grey poppins poppins--400 text--sm">
                    <p>
                        Para reservar esta experiencia comunícate con nosotros al <a class="a--grey" href="tel:+4421693408">442 169 34 08</a>
                    </p>
                    <p>
                        Incluye:
                    </p>
                    <ul class="m-0 p-0 ms-3">
                        <li>Teepee y decoración</li>
                        <li>Pizza 4 estaciones o pepperoni</li>
                        <li>Ensalada mixta</li>
                        <li>Botella de vino tinto o espumoso</li>
                        <li>Cine al aire libre (a partir de las 8 pm)</li>
                    </ul>
                    <p>
                        Costo del paquete: $1,657 pesos
                    </p>
                    <p>
                        Contacta a nuestro equipo de Ventas para reservar.
                        <a class="a--grey" href="tel:+4421693408">442 169 34 08</a>
                    </p>
                </div>
            </div>
        </div>
        <div id="paqueteCabana">
            <div class="romantic__galery">
                <div class="grid--3cols romantic__galery--images">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/c1.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/c2.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a6.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/c4.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/c5.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a6.png">
                </div>
                <div class="romantic__galery--bg">
                </div>
            </div>
            <div class="text--grey poppins poppins--400 text--sm">
                <p>
                    CENA ROMÁNTICA <br />
                    Paquete $2,329
                </p>
                <p>
                    INCLUYE
                </p>
                <p>
                    DECORACIÓN Y MONTAJE <br />
                    Mesa tipo picnic, mantelería, flores naturales, canasta con frazadas, cojines textura suave, puff de palma, tapete de palma. Iluminación: velas, faroles y antorchas. Vajilla y cristalería: platos, cubiertos, copas, vasos, jarra con agua.
                </p>
                <p>
                    ALIMENTOS <br />
                    A elegir Entrada:
                    <ul class="m-0 p-0 ms-3">
                        <li>Ensalada Capresse</li>
                        <li>Ensalada Mixta</li>
                    </ul>
                    A elegir plato fuerte:
                    <ul class="m-0 p-0 ms-3">
                        <li>Lomo de cerdo en salsa de miel</li>
                        <li>Costillas BBQ</li>
                        <li>Lasaña de carne</li>
                        <li>Pizza cuatro estaciones</li>
                    </ul>
                    Postre
                    <ul class="m-0 p-0 ms-3">
                        <li>Tiramisu</li>
                        <li>Crepa Dulce de pera con chocolate blanco</li>
                    </ul>
                </p>
                <p>
                    Las bebidas no están incluidas, puedes elegir entre los vinos de nuestra carta o traer tu botella y pagar un descorche de $185 pesos.
                </p>
            </div>
        </div>
        <div id="paqueteArmonia">
            <div class="romantic__galery">
                <div class="grid--3cols romantic__galery--images">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a1.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a2.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a3.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a4.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a5.png">
                    <img src="<?php echo __ROOT__; ?>/public/img/romantic/a6.png">
                </div>
                <div class="romantic__galery--bg">
                </div>
            </div>
            <div class="text--grey poppins poppins--400 text--sm">
                <p>
                    ¡Escápate a la naturaleza y renueva tu bienestar en Salterra Glamping! <br>
                    Sumérgete en una experiencia de lujo y relajación total con nuestro paquete exclusivo de hospedaje y spa. Disfruta de la serenidad de la naturaleza en nuestras tiendas, mientras te consientes con tratamientos rejuvenecedores. <br>
                    Este paquete de bienestar incluye:
                </p><br>
                <ul class="m-0 p-0 ms-3">
                    <li>Una noche de alojamiento de ensueño en nuestras tiendas glamping.</li>
                    <li>Dos masajes relajantes para liberar tensiones (60 mins).</li>
                    <li>Dos faciales hidratantes express para una piel radiante</li>
                    <li>Una sesión revitalizante de sauna y jacuzzi (90 mins).</li>
                    <li>Dos bebidas refrescantes para complementar tu relax.</li>
                    <li>Dos desayunos Salterra</li>
                </ul>
                <p>
                    ¡Permítete un respiro y recarga energías en Salterra Glamping! <br>
                    ¡Reserva ahora y vive la experiencia Salterra Glamping!
                </p>
            </div>
        </div>
    </section>

</main>

<script>
    function togglePackage(packageName) {
        const packages = ['paqueteCompromiso', 'paqueteAniversario', 'paqueteTeppee', 'paqueteCabana', 'paqueteArmonia'];
        packages.forEach(pkg => {
            document.getElementById(pkg).style.display = pkg === `paquete${packageName}` ? 'block' : 'none';
        });
    }

    // Initialize with the first package visible
    togglePackage('Compromiso');
</script>

<?php include 'partials/footer.php'; ?>
